﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    ''' <summary>
    '''出现以下情况时，使用这些自定义事件向 Forms 类发出通知：
    '''用户在 Form_Closing 事件过程中取消“Save”（保存），或者
    '''用户从“File”（文件）菜单选择“Exit”（退出）。
    ''' </summary>
    ''' <remarks></remarks>
    Public Event SaveWhileClosingCancelled As System.EventHandler
    Public Event ExitApplication As System.EventHandler

    Private dirtyValue As Boolean = False
    Private closingCompleteValue As Boolean = False
    Private documentNameValue As String
    Private fileNameValue As String

    Public ReadOnly Property ClosingComplete() As Boolean
        Get
            Return closingCompleteValue
        End Get
    End Property

    Public ReadOnly Property DocumentName() As String
        Get
            Return documentNameValue
        End Get
    End Property

    ''' <summary>
    '''此属性确定关闭窗体前是否需要保存数据。
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public Property Dirty() As Boolean
        Get
            Return dirtyValue
        End Get
        Set(ByVal Value As Boolean)
            If Value Then
                If Not Me.Text.EndsWith("*") Then
                    Me.Text = Me.Text & "*"

                    Me.sbDocInfo.Text = "Changes need to be saved."
                End If
            Else
                Me.sbDocInfo.Text = "Ready"
                '移除 *
                Me.Text = Me.Text.Substring(0, (Me.Text.Length - 1))
            End If

            dirtyValue = Value
        End Set
    End Property

    Public Property FileName() As String
        Get
            Return fileNameValue
        End Get
        Set(ByVal Value As String)
            fileNameValue = Value
            documentNameValue = System.IO.Path.GetFileNameWithoutExtension(fileNameValue)
            Me.Text = Me.DocumentName
        End Set
    End Property

    Private Sub Form1_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Try
            '将我们的 ClosingComplete 属性设置为 true，
            '以使 Forms 类知道可以
            '将我们从该类的集合中删除
            closingCompleteValue = True

            If Me.dirty Then
                '要求用户选择保存（“Yes”（是））、不保存（“No”（否））或停止关闭（“Cancel”（取消））
                Dim strDocTitle As String
                If Me.Text.EndsWith("*") Then
                    strDocTitle = Me.Text.Substring(0, (Me.Text.Length - 1))
                Else
                    strDocTitle = Me.Text
                End If

                Dim strMsg As String = String.Format("Do you want to save {0}?", strDocTitle)

                Select Case MessageBox.Show(strMsg, "Closing", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                    Case Windows.Forms.DialogResult.Yes                        '保存文档
                        Me.SaveDocument()
                    Case Windows.Forms.DialogResult.No
                        '不保存文档，仅退出
                        '在此处放置代码
                    Case Windows.Forms.DialogResult.Cancel
                        '停止关闭窗体。
                        e.Cancel = True
                        '如果用户取消关闭，我们需要将
                        '自己的窗体保存在主 Forms 集合中
                        closingCompleteValue = False
                        '引发事件以阻止应用程序继续
                        '关闭任何其他打开的文档
                        RaiseEvent SaveWhileClosingCancelled(Me, Nothing)
                End Select
            End If
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click
        '退出应用程序
        RaiseEvent ExitApplication(Me, Nothing)
    End Sub

    Private Sub mnuNew_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuNew.Click
        '创建新的文档实例
        Forms.NewForm()
    End Sub

    Private Sub mnuSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuSave.Click
        Me.SaveDocument()
    End Sub

    Private Sub mnuClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuClose.Click
        Me.Close()
    End Sub

    Private Sub txtData_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtData.TextChanged
        '如果数据已更改，则将窗体的 Dirty 属性设置为 True
        Me.Dirty = True
    End Sub

    Private Sub SaveDocument()
        '此代码不执行任何文件 I/O。
        Try
            '检查文档是否已更新
            If Me.Dirty Then
                '检查是否存在文件（文档）名
                If Not Me.FileName Is Nothing Then
                    '将现有文档保存到文件
                Else
                    '没有文件名，要求一个文件名。
                    '有关使用“Save”（保存）通用对话框的示例，
                    '请参见通用对话框帮助

                    '我们将根据文档标题和当前应用程序的目录
                    '创建一个文件名
                    Me.FileName = AppDomain.CurrentDomain.BaseDirectory & "Saved" & Me.Text
                End If

                '保存文档后，重置 Dirty 位
                Me.Dirty = False
            End If
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub MainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class

